/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.api.VWException;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWConvertTwo;
import filenet.vw.base.VWFnSessShr;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Logger;
import filenet.vw.server.VWCapsule;

public class VWTokenHelper {
    private static final Logger logger = Logger.getLogger("filenet.pe.peorb.client.token");
    private static final String m_className = "VWTokenHelper";
    private static final int KEY_MASK = 0;
    private String token = null;
    private String name = null;
    private String pw = null;
    private String ceURI = null;
    private String cp = null;
    private static boolean newFormat = false;
    private String m_desc = null;

    public static void setUseNewFormat(boolean b) {
        newFormat = b;
    }

    private static String EncryptToken(String s) throws VWException {
        return new VWCapsule(s).getStr();
    }

    private static String DecryptToken(String s) throws VWException {
        VWCapsule vwcp = new VWCapsule();
        vwcp.setString(s);
        return vwcp.getString();
    }

    private VWTokenHelper(String name, String pw, String ceURI, String cp) throws VWException {
        try {
            this.name = name;
            this.pw = pw;
            this.ceURI = ceURI;
            this.cp = cp;
            if (newFormat) {
                this.makeTokenForNewFormat();
            } else {
                this.token = new VWFnSessShr().encrypt(name, pw);
                if (this.token == null) {
                    this.makeTokenForNewFormat();
                }
            }
        }
        catch (Throwable t) {
            throw new VWException(t);
        }
    }

    private VWTokenHelper(String s) throws VWException {
        String m_method = "ctor:" + s;
        if (newFormat) {
            this.extractTokenFromNewFormat(s);
        } else {
            this.token = s;
            VWFnSessShr fnSessShr = new VWFnSessShr();
            VWAuthItem item = fnSessShr.decrypt(s);
            if (item != null) {
                this.name = item.getName();
                this.pw = item.getPassword();
            } else {
                this.extractTokenFromNewFormat(s);
            }
        }
    }

    private void makeTokenForNewFormat() throws Exception, VWException {
        StringBuffer buf = new StringBuffer();
        buf.append("<t>").append("<c>").append(new VWCMConvertTwo(0).getEString(this.name, this.pw)).append("</c>").append("<cp>").append(XMLHelper.toXMLString(this.cp)).append("</cp>").append("<ce>").append(XMLHelper.toXMLString(this.ceURI)).append("</ce>").append("</t>");
        String s = buf.toString();
        if (logger.isFinest()) {
            logger.finest(m_className, "makeTokenForNewFormat-before", s);
        }
        this.token = VWTokenHelper.EncryptToken(s);
        if (logger.isFinest()) {
            logger.finest(m_className, "makeTokenForNewFormat-after", this.token);
        }
    }

    private void extractTokenFromNewFormat(String s) throws VWException {
        String m_method = "extractTokenFromNewFormat";
        if (logger.isFinest()) {
            logger.finest(m_className, "extractTokenFromNewFormat", s);
        }
        this.token = VWTokenHelper.DecryptToken(s);
        if (logger.isFinest()) {
            logger.finest(m_className, "extractTokenFromNewFormat", "AFTER=" + this.token);
        }
        VWXMLWrapper xml = null;
        try {
            xml = new VWXMLWrapper(this.token);
        }
        catch (Throwable t) {
            throw new VWException(t);
        }
        String nodeName = xml.getRootNode().getLocalName();
        if (!nodeName.equals("t")) {
            throw new VWException("vw.base.tokenhelper.invalidToken", "Invalid Token.");
        }
        String sAuth = VWXMLWrapper.getNodeValue(xml.getRootNode(), "c");
        this.cp = VWXMLWrapper.getNodeValue(xml.getRootNode(), "cp");
        this.ceURI = VWXMLWrapper.getNodeValue(xml.getRootNode(), "ce");
        if (sAuth == null || sAuth.trim().length() == 0 || this.cp == null || this.cp.trim().length() == 0) {
            throw new VWException("vw.base.tokenhelper.invalidToken", "Invalid Token.");
        }
        VWCMConvertTwo converter = new VWCMConvertTwo(0);
        VWAuthItem item = null;
        try {
            item = converter.getDString(sAuth);
        }
        catch (Exception e) {
            throw new VWException(e);
        }
        if (item != null) {
            this.name = item.getName();
            this.pw = item.getPassword();
            if (this.pw == null || this.pw != null && this.pw.compareTo("\"\"") == 0) {
                this.pw = "";
            }
            if (logger.isFinest()) {
                logger.finest(m_className, "extractTokenFromNewFormat", this.name + "," + this.pw.length());
            }
        }
    }

    public String toString() {
        if (this.m_desc == null) {
            this.m_desc = new StringBuffer().append("n=").append(this.name).append(", cp=").append(this.cp).append(", ceURI=").append(this.ceURI).toString();
        }
        return this.m_desc;
    }

    public String getToken() {
        return this.token;
    }

    public String getName() {
        return this.name;
    }

    public String getPw() {
        return this.pw;
    }

    public String getCeURI() {
        return this.ceURI;
    }

    public String getCp() {
        return this.cp;
    }

    public static String GetToken(String name, String pw, String ceURI, String cp) throws VWException {
        return new VWTokenHelper(name, pw, ceURI, cp).getToken();
    }

    public static VWTokenHelper GetToken(String token) throws VWException {
        return new VWTokenHelper(token);
    }

    public static String _get_FILE_DATE() {
        return "$Date:   08 Oct 2007 19:53:22  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.5  $";
    }

    public static void main(String[] args) {
        try {
            String name = "myName";
            String pw = "wwwwxxx";
            String cp = "myCP";
            String ceURI = "t3://host:7002/FileNet/Engine";
            String tok = VWTokenHelper.GetToken(name, pw, ceURI, cp);
            System.out.println("tok=" + tok);
            VWTokenHelper helper = VWTokenHelper.GetToken(tok);
            System.out.println("parsing back=" + helper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            newFormat = System.getProperty("filenet.pe.new.token") != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    final class VWCMConvertTwo
    extends VWConvertTwo {
        int KEY_MASK = 0;

        protected VWCMConvertTwo(int mask) {
            this.KEY_MASK = mask;
        }

        protected String getKey(int id) {
            return "MIIBCTCBtAIBADBPMQswCQYDeQQGEwJV6s4fUzEQMA4GA1UECBMHRmxvcmlkYTEYMBYGA1UEChMPRXllcyBvbiBUaGUgV2ViMRQwEgYDVQQDFAt3d3cuZXR3Lm5ldDBcMA0GCSqGSIb3DQEBAQUAA0sAMEgCQQCeojtjnHqg0GTxp+XZ56RaSe1iZWpumXjU6Sx7v1FdXzsY1oLOQa090Jtnu1WsQRHh0yDS+45oncjKm1zCIZAgMBAAGgADANBgkqhkiG9w0BAQQFAANBAFBj9g+NiUh8YWPrFGntgf4miUdwqUshptjJy4PjdsD*3ugy5avvuh3GPpGh2aYXIjHpJXTUBQyzxSEIINYtc";
        }

        protected String getEString(String name, String password) throws Exception {
            return super.getEString(name, password);
        }

        protected VWAuthItem getDString(String token) throws Exception {
            return super.getDString(token);
        }
    }
}

